// UIndex.cp
// UIndex.h
// ----------------------------------------------------------------------------------
// This class is an index for a main dictionary.
// ----------------------------------------------------------------------------------
// History:
// 		Art Pollard			June 94
//			Original.  
//		Clark Goble			08/12/94
//			Made the index into an abstract C++ class.
// ----------------------------------------------------------------------------------

#include <stdio.h>
#include "Tspell.h"
#include "UExtend.h"
#include "Uio.h"

#ifndef _UINDEX_
#define _UINDEX_

// ----------------------------------------------------------------------------------
// Includes

#define MAX_WORD_TABLE_LENGTH     32768
#define MAX_NUMBER_WORD_POINTERS  2000


class UIndex:public UExtended {
public:
	UIndex();
	~UIndex();

	short		Create();
	void	Clear();
	void	Insert(UInt8 	*Word);
	short		Write(Uio 	*File, long Offset);
	short		Write(FILE 	*File, long Offset);
	short		Read(Uio 	*File, long Offset);
	short		CreateWordPointers();
	short		FindPage(short guess, UInt8 *Word);

	int			NumWords;			// number of words in the table

private:

	UInt8			*WordTable;		// List of words
	size_t		*WordPtr;			// Pointer to a list of indexes that index into
								// the word table
	size_t		position;			// position in the table
	size_t 		TableSize;		// size of the table
};

#endif

